DROP TABLE IF EXISTS `site_core_widgets`;
CREATE TABLE `site_core_widgets` (
  `widget_id` int(11) NOT NULL AUTO_INCREMENT,
  `widget_type` varchar(100) NOT NULL,
  `widget_type_name` varchar(255) NOT NULL,
  `widget_module` int(11) NOT NULL,
  `widget_module_type` int(1) NOT NULL,
  `widget_settings` longtext NOT NULL,
  `widget_status` int(1) NOT NULL,
  `widget_system` int(1) NOT NULL,
  `widget_cache` int(11) NOT NULL,
  `widget_show_title` int(1) NOT NULL,
  `widget_perm` int(1) NOT NULL,
  `widget_perm_groups` text NOT NULL,
  `widget_perm_memberships` text NOT NULL,
  `widget_disable_title` int(1) NOT NULL,
  `widget_device` char(10) NOT NULL DEFAULT '1,2,3',
  `widget_css_class` varchar(255) NOT NULL,
  `widget_bg` int(11) NOT NULL,
  `widget_note` varchar(100) NOT NULL,
  `widget_link2_type` int(1) NOT NULL,
  `widget_link2_module` int(11) NOT NULL,
  `widget_link2_target` varchar(10) NOT NULL,
  `widget_link2_size` varchar(10) NOT NULL DEFAULT 'btn-small',
  `widget_link2_global` int(11) NOT NULL,
  `widget_link_type` int(1) NOT NULL,
  `widget_link_module` int(11) NOT NULL,
  `widget_link_target` varchar(10) NOT NULL,
  `widget_link_size` varchar(10) NOT NULL DEFAULT 'btn-small',
  `widget_link_global` int(11) NOT NULL,
  `widget_link_rel` varchar(30) NOT NULL,
  `widget_link2_rel` varchar(30) NOT NULL,
  `widget_link_style` varchar(50) NOT NULL,
  `widget_link2_style` varchar(50) NOT NULL,
  PRIMARY KEY (`widget_id`),
  KEY `widget_module` (`widget_module`),
  KEY `widget_device` (`widget_device`),
  KEY `widget_module_type` (`widget_module_type`),
  KEY `widget_status` (`widget_status`),
  KEY `widget_perm` (`widget_perm`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `site_core_widgets_lang`;
CREATE TABLE `site_core_widgets_lang` (
  `widget_id` int(11) NOT NULL,
  `lang_id` int(2) NOT NULL,
  `widget_name` varchar(255) NOT NULL,
  `widget_set_lang` longtext NOT NULL,
  `widget_cache_data` longtext NOT NULL,
  `widget_cache_update` int(11) NOT NULL,
  `widget_header` text NOT NULL,
  `widget_footer` text NOT NULL,
  `widget_link_text` varchar(100) NOT NULL,
  `widget_link_link` text NOT NULL,
  `widget_link2_link` text NOT NULL,
  `widget_link2_text` text NOT NULL,
  KEY `widget_id` (`widget_id`),
  KEY `lang_id` (`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `site_core_widgets_static`;
CREATE TABLE `site_core_widgets_static` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `item_order` int(11) NOT NULL,
  `widget_id` int(11) NOT NULL,
  `item_vars` text NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `widget_id` (`widget_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_core_widgets_static_lang`;
CREATE TABLE `site_core_widgets_static_lang` (
  `item_id` int(11) NOT NULL,
  `widget_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `item_vars_lang` text NOT NULL,
  KEY `item_id` (`item_id`,`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


INSERT INTO `site_core_widgets` (`widget_id`, `widget_type`, `widget_type_name`, `widget_module`, `widget_module_type`, `widget_settings`, `widget_status`, `widget_system`, `widget_cache`, `widget_show_title`, `widget_perm`, `widget_perm_groups`, `widget_perm_memberships`) VALUES
(-1, 'cwidgetswidgetmodule', 'Base Module', 106, 2, '', 1, 1, 0, 1, 0, '', '');


INSERT INTO `site_core_widgets_lang` (`widget_id`, `lang_id`, `widget_name`, `widget_set_lang`, `widget_cache_data`, `widget_cache_update`) VALUES
(-1, 1, 'Base Module', '', '', 0);
